<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;

    public function paymentMethods()
    {
        return $this->hasMany('PaymentMethods');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function billingAddress()
    {
        return $this->hasOne('Address');
    }

}